(function(blocks, element, editor, components) {
    var el = element.createElement;
    var InspectorControls = editor.InspectorControls;
    var PanelBody = components.PanelBody;
    var TextControl = components.TextControl;
    var SelectControl = components.SelectControl;
    var Placeholder = components.Placeholder;

    blocks.registerBlockType('bookingflow/booking-widget', {
        title: 'BookingFlow Widget',
        icon: 'calendar-alt',
        category: 'widgets',
        attributes: {
            tenant: {
                type: 'string',
                default: ''
            },
            width: {
                type: 'string',
                default: '100%'
            },
            height: {
                type: 'string',
                default: '800px'
            },
            mode: {
                type: 'string',
                default: 'embed'
            }
        },

        edit: function(props) {
            var attributes = props.attributes;
            var setAttributes = props.setAttributes;

            function onChangeTenant(newTenant) {
                setAttributes({ tenant: newTenant });
            }

            function onChangeWidth(newWidth) {
                setAttributes({ width: newWidth });
            }

            function onChangeHeight(newHeight) {
                setAttributes({ height: newHeight });
            }

            function onChangeMode(newMode) {
                setAttributes({ mode: newMode });
            }

            return [
                el(InspectorControls, {},
                    el(PanelBody, { title: 'BookingFlow Instellingen', initialOpen: true },
                        el(TextControl, {
                            label: 'Tenant Slug',
                            value: attributes.tenant,
                            onChange: onChangeTenant,
                            help: 'De unieke identifier van je BookingFlow account'
                        }),
                        el(SelectControl, {
                            label: 'Weergave Modus',
                            value: attributes.mode,
                            options: [
                                { label: 'Embed (ingesloten)', value: 'embed' },
                                { label: 'Button (link)', value: 'button' }
                            ],
                            onChange: onChangeMode
                        }),
                        attributes.mode === 'embed' && el(TextControl, {
                            label: 'Breedte',
                            value: attributes.width,
                            onChange: onChangeWidth,
                            help: 'Bijv: 100% of 800px'
                        }),
                        attributes.mode === 'embed' && el(TextControl, {
                            label: 'Hoogte',
                            value: attributes.height,
                            onChange: onChangeHeight,
                            help: 'Bijv: 800px'
                        })
                    )
                ),
                el(Placeholder, {
                    icon: 'calendar-alt',
                    label: 'BookingFlow Widget',
                    instructions: attributes.tenant
                        ? 'BookingFlow widget voor: ' + attributes.tenant
                        : 'Configureer je BookingFlow widget in de sidebar rechts'
                },
                    !attributes.tenant && el('p', {
                        style: {
                            color: '#d63638',
                            margin: '10px 0 0 0'
                        }
                    }, 'Let op: Vul eerst je tenant slug in')
                )
            ];
        },

        save: function() {
            // Dynamic block - rendered via PHP
            return null;
        }
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.blockEditor || window.wp.editor,
    window.wp.components
);
