<?php
/**
 * BookingFlow Settings Page Template
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap bookingflow-settings">
    <h1><?php _e('BookingFlow Instellingen', 'bookingflow'); ?></h1>

    <div class="bookingflow-header">
        <img src="<?php echo esc_url(BOOKINGFLOW_PLUGIN_URL . 'assets/logo.svg'); ?>" alt="BookingFlow" style="height: 40px; margin-bottom: 20px;">
        <p class="description">
            <?php _e('Integreer BookingFlow op je WordPress website en laat bezoekers direct reserveringen maken.', 'bookingflow'); ?>
        </p>
    </div>

    <?php if (empty($tenant_slug)): ?>
        <div class="notice notice-warning">
            <p>
                <strong><?php _e('Let op:', 'bookingflow'); ?></strong>
                <?php _e('Je hebt nog geen BookingFlow account ingesteld. Vul hieronder je tenant slug in om te beginnen.', 'bookingflow'); ?>
            </p>
        </div>
    <?php endif; ?>

    <div class="bookingflow-content">
        <div class="bookingflow-main">
            <form method="post" action="">
                <?php wp_nonce_field('bookingflow_settings'); ?>

                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="tenant_slug"><?php _e('Tenant Slug', 'bookingflow'); ?> *</label>
                        </th>
                        <td>
                            <input type="text"
                                   id="tenant_slug"
                                   name="tenant_slug"
                                   value="<?php echo esc_attr($tenant_slug); ?>"
                                   class="regular-text"
                                   placeholder="bijv: jouw-bedrijf"
                                   required>
                            <p class="description">
                                <?php _e('De unieke identifier van je BookingFlow account. Deze vind je in je BookingFlow dashboard.', 'bookingflow'); ?>
                                <br>
                                <?php _e('URL formaat:', 'bookingflow'); ?> <code>bookingflow.nl/booking/<strong>jouw-slug</strong></code>
                            </p>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row">
                            <label for="display_mode"><?php _e('Weergave Modus', 'bookingflow'); ?></label>
                        </th>
                        <td>
                            <select id="display_mode" name="display_mode">
                                <option value="embed" <?php selected($display_mode, 'embed'); ?>>
                                    <?php _e('Embed (ingesloten in pagina)', 'bookingflow'); ?>
                                </option>
                                <option value="button" <?php selected($display_mode, 'button'); ?>>
                                    <?php _e('Button (link naar booking pagina)', 'bookingflow'); ?>
                                </option>
                            </select>
                            <p class="description">
                                <?php _e('Kies hoe de booking widget wordt weergegeven op je website.', 'bookingflow'); ?>
                            </p>
                        </td>
                    </tr>

                    <tr id="width_row">
                        <th scope="row">
                            <label for="width"><?php _e('Breedte', 'bookingflow'); ?></label>
                        </th>
                        <td>
                            <input type="text"
                                   id="width"
                                   name="width"
                                   value="<?php echo esc_attr($width); ?>"
                                   class="regular-text"
                                   placeholder="100%">
                            <p class="description">
                                <?php _e('Breedte van de widget (bijv: 100%, 800px). Alleen voor embed modus.', 'bookingflow'); ?>
                            </p>
                        </td>
                    </tr>

                    <tr id="height_row">
                        <th scope="row">
                            <label for="height"><?php _e('Hoogte', 'bookingflow'); ?></label>
                        </th>
                        <td>
                            <input type="text"
                                   id="height"
                                   name="height"
                                   value="<?php echo esc_attr($height); ?>"
                                   class="regular-text"
                                   placeholder="800px">
                            <p class="description">
                                <?php _e('Hoogte van de widget in pixels (bijv: 800px). Alleen voor embed modus.', 'bookingflow'); ?>
                            </p>
                        </td>
                    </tr>
                </table>

                <p class="submit">
                    <button type="submit" name="bookingflow_save_settings" class="button button-primary">
                        <?php _e('Instellingen Opslaan', 'bookingflow'); ?>
                    </button>
                </p>
            </form>
        </div>

        <div class="bookingflow-sidebar">
            <!-- Usage Instructions -->
            <div class="postbox">
                <h2 class="hndle"><?php _e('Hoe te gebruiken', 'bookingflow'); ?></h2>
                <div class="inside">
                    <h4><?php _e('Shortcode', 'bookingflow'); ?></h4>
                    <p><?php _e('Plak deze shortcode in elke pagina of post:', 'bookingflow'); ?></p>
                    <code style="display: block; padding: 10px; background: #f5f5f5; border-radius: 4px; margin: 10px 0;">
                        [bookingflow]
                    </code>

                    <h4 style="margin-top: 20px;"><?php _e('Met aangepaste instellingen:', 'bookingflow'); ?></h4>
                    <code style="display: block; padding: 10px; background: #f5f5f5; border-radius: 4px; margin: 10px 0;">
                        [bookingflow tenant="jouw-slug" mode="embed" width="100%" height="800px"]
                    </code>

                    <h4 style="margin-top: 20px;"><?php _e('Gutenberg Block', 'bookingflow'); ?></h4>
                    <p><?php _e('In de block editor, zoek naar "BookingFlow" en voeg het block toe.', 'bookingflow'); ?></p>
                </div>
            </div>

            <!-- Get Started -->
            <div class="postbox">
                <h2 class="hndle"><?php _e('Nog geen BookingFlow account?', 'bookingflow'); ?></h2>
                <div class="inside">
                    <p><?php _e('Start vandaag nog met BookingFlow en ontvang reserveringen via je website.', 'bookingflow'); ?></p>
                    <a href="https://bookingflow.nl/signup" target="_blank" class="button button-secondary" style="width: 100%; text-align: center;">
                        <?php _e('Account Aanmaken', 'bookingflow'); ?>
                    </a>
                </div>
            </div>

            <!-- Preview -->
            <?php if (!empty($tenant_slug)): ?>
            <div class="postbox">
                <h2 class="hndle"><?php _e('Preview', 'bookingflow'); ?></h2>
                <div class="inside">
                    <p><?php _e('Test je booking widget:', 'bookingflow'); ?></p>
                    <a href="<?php echo esc_url(BOOKINGFLOW_BASE_URL . '/booking/' . $tenant_slug); ?>" target="_blank" class="button button-secondary" style="width: 100%; text-align: center;">
                        <?php _e('Open Booking Widget', 'bookingflow'); ?>
                    </a>
                </div>
            </div>
            <?php endif; ?>

            <!-- Support -->
            <div class="postbox">
                <h2 class="hndle"><?php _e('Hulp nodig?', 'bookingflow'); ?></h2>
                <div class="inside">
                    <p>
                        <strong><?php _e('Email:', 'bookingflow'); ?></strong><br>
                        <a href="mailto:support@bookingflow.nl">support@bookingflow.nl</a>
                    </p>
                    <p>
                        <strong><?php _e('Telefoon:', 'bookingflow'); ?></strong><br>
                        +31 (0)85 060 60 60<br>
                        <small>Ma-Vr 09:00-17:00</small>
                    </p>
                    <p>
                        <strong><?php _e('Documentatie:', 'bookingflow'); ?></strong><br>
                        <a href="https://bookingflow.nl" target="_blank">bookingflow.nl</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .bookingflow-settings {
        max-width: 1200px;
    }

    .bookingflow-header {
        background: white;
        padding: 20px;
        margin: 20px 0;
        border-radius: 8px;
        border: 1px solid #ddd;
    }

    .bookingflow-content {
        display: grid;
        grid-template-columns: 1fr 350px;
        gap: 20px;
        margin-top: 20px;
    }

    .bookingflow-main {
        background: white;
        padding: 20px;
        border-radius: 8px;
        border: 1px solid #ddd;
    }

    .bookingflow-sidebar {
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .bookingflow-sidebar .postbox {
        border: 1px solid #ddd;
        border-radius: 8px;
    }

    .bookingflow-sidebar .postbox h2 {
        padding: 15px;
        margin: 0;
        border-bottom: 1px solid #ddd;
        font-size: 14px;
        font-weight: 600;
    }

    .bookingflow-sidebar .postbox .inside {
        padding: 15px;
    }

    .bookingflow-sidebar .postbox .inside h4 {
        margin: 0 0 5px 0;
        font-size: 13px;
    }

    .bookingflow-sidebar .postbox .inside p {
        margin: 0 0 10px 0;
        font-size: 13px;
    }

    @media (max-width: 1024px) {
        .bookingflow-content {
            grid-template-columns: 1fr;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var displayMode = document.getElementById('display_mode');
        var widthRow = document.getElementById('width_row');
        var heightRow = document.getElementById('height_row');

        function toggleDimensionFields() {
            if (displayMode.value === 'embed') {
                widthRow.style.display = 'table-row';
                heightRow.style.display = 'table-row';
            } else {
                widthRow.style.display = 'none';
                heightRow.style.display = 'none';
            }
        }

        displayMode.addEventListener('change', toggleDimensionFields);
        toggleDimensionFields();
    });
</script>
