# BookingFlow WordPress Plugin

![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)
![WordPress](https://img.shields.io/badge/wordpress-5.8%2B-green.svg)
![PHP](https://img.shields.io/badge/php-7.4%2B-purple.svg)
![License](https://img.shields.io/badge/license-GPL%20v2-red.svg)

Integreer BookingFlow reserveringssysteem op je WordPress website. Laat bezoekers direct boeken via een professionele booking widget.

## 📋 Overzicht

BookingFlow is een krachtig reserveringssysteem dat je eenvoudig kunt integreren op je WordPress website. Met deze plugin plaats je in enkele klikken een volledig functionele booking widget op elke pagina.

## ✨ Features

* ✅ **Eenvoudige Integratie** - Gebruik shortcode of Gutenberg block
* ✅ **Twee Weergave Modi** - Embed (ingesloten) of Button (link)
* ✅ **Volledig Aanpasbaar** - Stel breedte en hoogte in
* ✅ **Responsive Design** - Werkt perfect op mobiel en desktop
* ✅ **Geen Configuratie** - Alleen je tenant slug invoeren
* ✅ **Real-time Beschikbaarheid** - Live kalendersynchronisatie
* ✅ **Professioneel** - Mooie UI met jouw bedrijfsbranding

## 🚀 Installatie

### Automatisch (aanbevolen)

1. Ga naar je WordPress dashboard
2. Klik op **Plugins** → **Nieuwe plugin**
3. Zoek naar "BookingFlow"
4. Klik op **Installeer** en daarna op **Activeer**

### Handmatig

1. Download de plugin als ZIP bestand
2. Upload naar `/wp-content/plugins/bookingflow/`
3. Activeer de plugin via 'Plugins' menu in WordPress

## ⚙️ Configuratie

1. Ga naar **BookingFlow** in het WordPress menu
2. Vul je **Tenant Slug** in (bijv: "jouw-bedrijf")
3. Kies je **Weergave Modus** (embed of button)
4. Stel eventueel **Breedte** en **Hoogte** in
5. Klik op **Instellingen Opslaan**

### Waar vind ik mijn Tenant Slug?

Je tenant slug is de unieke identifier in je BookingFlow booking URL:
```
https://bookingflow.nl/booking/JOUW-SLUG
                                ^^^^^^^^
```

## 📝 Gebruik

### Shortcode (eenvoudigste manier)

Plaats deze shortcode op elke pagina of post:

```
[bookingflow]
```

### Met aangepaste instellingen

```
[bookingflow tenant="jouw-bedrijf" mode="embed" width="100%" height="800px"]
```

### Parameters

| Parameter | Type | Default | Beschrijving |
|-----------|------|---------|--------------|
| `tenant` | string | (instellingen) | Je BookingFlow tenant slug |
| `mode` | string | "embed" | Weergave modus: "embed" of "button" |
| `width` | string | "100%" | Breedte (alleen embed mode) |
| `height` | string | "800px" | Hoogte (alleen embed mode) |

### Voorbeelden

**Standaard embed:**
```
[bookingflow]
```

**Custom tenant met grotere hoogte:**
```
[bookingflow tenant="beauty-salon" height="1000px"]
```

**Button mode:**
```
[bookingflow mode="button"]
```

**Vaste breedte:**
```
[bookingflow width="800px" height="900px"]
```

### Gutenberg Block

In de Gutenberg editor:

1. Klik op **+** om een nieuw block toe te voegen
2. Zoek naar "BookingFlow"
3. Configureer de instellingen in de sidebar rechts
4. Publiceer de pagina

## 🎨 Weergave Modi

### Embed Mode

Toont de volledige booking widget direct op je pagina in een iframe. Bezoekers kunnen de volledige booking flow doorlopen zonder je website te verlaten.

**Voordelen:**
- Naadloze integratie
- Bezoekers blijven op je website
- Professionele uitstraling

**Gebruik:**
```
[bookingflow mode="embed"]
```

### Button Mode

Toont een mooie call-to-action button die linkt naar je booking pagina.

**Voordelen:**
- Minimale ruimte nodig
- Snel en lichtgewicht
- Perfect voor sidebar of header

**Gebruik:**
```
[bookingflow mode="button"]
```

## 🔧 Technische Specificaties

### Systeemvereisten

- WordPress 5.8 of hoger
- PHP 7.4 of hoger
- Actief BookingFlow account

### Browser Ondersteuning

- Chrome (laatste 2 versies)
- Firefox (laatste 2 versies)
- Safari (laatste 2 versies)
- Edge (laatste 2 versies)
- Mobile browsers (iOS Safari, Chrome Android)

### Performance

- **Plugin size:** < 100KB
- **Load time:** < 50ms
- **No external dependencies** (behalve BookingFlow iframe)

## 💡 Best Practices

### 1. Dedicated Booking Pagina

Maak een aparte pagina voor reserveringen:
- URL: `/reserveren` of `/afspraak-maken`
- Template: Full width (geen sidebar)
- Plaats shortcode: `[bookingflow height="1000px"]`

### 2. Landing Page Integratie

Gebruik button mode op landing pages:
```
[bookingflow mode="button"]
```

### 3. Multi-locatie Setup

Als je meerdere locaties hebt met eigen BookingFlow accounts:

**Pagina Amsterdam:**
```
[bookingflow tenant="salon-amsterdam"]
```

**Pagina Rotterdam:**
```
[bookingflow tenant="salon-rotterdam"]
```

### 4. Responsive Hoogte

Voor verschillende devices kun je CSS media queries gebruiken:

```css
.bookingflow-embed-container iframe {
    height: 800px;
}

@media (max-width: 768px) {
    .bookingflow-embed-container iframe {
        height: 1000px;
    }
}
```

## 🐛 Troubleshooting

### Widget wordt niet weergegeven

**Probleem:** Je ziet een foutmelding of lege ruimte

**Oplossing:**
1. Controleer of je tenant slug correct is
2. Ga naar BookingFlow instellingen en klik "Opslaan"
3. Clear je WordPress cache (als je een cache plugin gebruikt)
4. Test de booking URL direct: `https://bookingflow.nl/booking/JOUW-SLUG`

### iframe is te klein/groot

**Probleem:** De widget past niet goed op de pagina

**Oplossing:**
1. Pas de height parameter aan: `[bookingflow height="1200px"]`
2. Voor responsive gedrag: gebruik `height="100vh"` voor volledige schermhoogte
3. Test op verschillende apparaten

### Button doet niets

**Probleem:** Klikken op de button opent geen booking pagina

**Oplossing:**
1. Controleer browser console voor JavaScript errors
2. Controleer of je tenant slug correct is ingesteld
3. Test in incognito mode (om cache issues uit te sluiten)

### Styling conflicten

**Probleem:** De widget of button ziet er raar uit

**Oplossing:**
1. Controleer of je theme geen conflicterende CSS heeft
2. Gebruik Custom CSS om specifieke styling te overschrijven:
```css
.bookingflow-embed-container {
    /* Jouw custom styling */
}
```

## 📞 Support

Heb je hulp nodig? Ons team staat voor je klaar:

- **Email:** support@bookingflow.nl
- **Telefoon:** +31 (0)85 060 60 60
- **Bereikbaar:** Ma-Vr 09:00-17:00
- **Website:** [bookingflow.nl](https://bookingflow.nl)

## 🔐 Privacy & Beveiliging

- **Geen data opslag:** De plugin slaat geen persoonlijke gegevens op
- **Secure iframe:** Alle communicatie verloopt via HTTPS
- **GDPR compliant:** BookingFlow is volledig AVG-proof
- **No tracking:** De plugin gebruikt geen cookies of tracking

## 📄 Licentie

Deze plugin is gelicenseerd onder GPL v2 or later.

Copyright © 2025 BookingFlow. Alle rechten voorbehouden.

## 🎯 Nog geen BookingFlow account?

Start vandaag nog met BookingFlow en ontvang reserveringen via je website.

**Features van BookingFlow:**
- ✅ Online agenda & kalender
- ✅ Automatische bevestigingsmails
- ✅ SMS notificaties
- ✅ Klantendatabase
- ✅ Multi-resource planning
- ✅ Terugkerende afspraken
- ✅ Betalingen via Mollie/Stripe
- ✅ Rapporten & analytics

**Prijzen vanaf €29/maand**

👉 [Account aanmaken op BookingFlow.nl](https://bookingflow.nl/signup)

---

Made with ❤️ by BookingFlow
