# 📦 BookingFlow WordPress Plugin - Installatie Instructies

## Voor Eindgebruikers (WordPress Site Eigenaren)

### Stap 1: Download de Plugin

Download het bestand `bookingflow.zip` naar je computer.

### Stap 2: Installeer via WordPress

1. Log in op je WordPress admin dashboard
2. Ga naar **Plugins** → **Nieuwe plugin**
3. Klik op **Plugin uploaden** (bovenaan de pagina)
4. Klik op **Bestand kiezen** en selecteer `bookingflow.zip`
5. Klik op **Nu installeren**
6. Klik op **Plugin activeren**

### Stap 3: Configureer de Plugin

1. Ga in het WordPress menu naar **BookingFlow** (nieuw menu item met kalender icoon)
2. Vul je **Tenant Slug** in
   - Dit is de unieke identifier van je BookingFlow account
   - Format: `jouw-bedrijfsnaam` (zonder spaties, alleen letters en streepjes)
   - Je vindt deze in je BookingFlow dashboard
3. Kies je **Weergave Modus:**
   - **Embed:** Volledige widget op je pagina (aanbevolen)
   - **Button:** Een knop die naar je booking pagina linkt
4. Pas eventueel **Breedte** en **Hoogte** aan (alleen voor embed mode)
5. Klik op **Instellingen Opslaan**

### Stap 4: Plaats de Widget op je Website

**Optie A: Via Shortcode (eenvoudigst)**

1. Maak een nieuwe pagina aan of bewerk een bestaande
2. Plaats deze shortcode in de content:
   ```
   [bookingflow]
   ```
3. Publiceer de pagina
4. Bekijk de pagina - je ziet nu de booking widget!

**Optie B: Via Gutenberg Block Editor**

1. Open de pagina editor
2. Klik op **+** om een nieuw block toe te voegen
3. Zoek naar "BookingFlow"
4. Klik op het **BookingFlow Widget** block
5. Pas eventueel instellingen aan in de sidebar (rechts)
6. Publiceer de pagina

### Klaar! 🎉

Je booking widget is nu live op je website. Bezoekers kunnen direct reserveringen maken.

---

## Voor Developers & Systeembeheerders

### Vereisten

- WordPress 5.8+
- PHP 7.4+
- Actief BookingFlow tenant account

### Handmatige Installatie via FTP

1. Download en unzip `bookingflow.zip`
2. Upload de `bookingflow` map naar `/wp-content/plugins/`
3. Activeer via WordPress admin: **Plugins** → **Geïnstalleerde plugins**
4. Configureer via **BookingFlow** menu

### Installatie via WP-CLI

```bash
wp plugin install bookingflow.zip --activate
wp option update bookingflow_tenant_slug 'jouw-slug'
```

### Programmatische Configuratie

```php
// In theme functions.php of custom plugin
update_option('bookingflow_tenant_slug', 'jouw-bedrijf');
update_option('bookingflow_display_mode', 'embed');
update_option('bookingflow_width', '100%');
update_option('bookingflow_height', '800px');
```

### Shortcode in Theme Template

```php
<?php echo do_shortcode('[bookingflow]'); ?>
```

### Custom CSS Targeting

```css
/* Target de container */
.bookingflow-embed-container {
    /* Jouw styling */
}

/* Target de iframe */
.bookingflow-embed-container iframe {
    /* Jouw styling */
}

/* Target de button */
.bookingflow-button {
    /* Jouw styling */
}
```

### Filters & Hooks (voor developers)

**Filter booking URL:**
```php
add_filter('bookingflow_url', function($url, $tenant) {
    // Modify URL before rendering
    return $url;
}, 10, 2);
```

**Customize button text:**
```php
add_filter('bookingflow_button_text', function($text) {
    return 'Maak een Afspraak';
});
```

---

## Troubleshooting

### Plugin Activatie Faalt

**Fout:** "Plugin could not be activated"

**Oplossing:**
- Check PHP versie (minimaal 7.4)
- Check WordPress versie (minimaal 5.8)
- Controleer file permissions: `chmod 755 /wp-content/plugins/bookingflow`

### Widget Toont Foutmelding

**Fout:** "Geen tenant slug ingesteld"

**Oplossing:**
- Ga naar **BookingFlow** instellingen
- Vul je tenant slug in
- Klik "Opslaan"

### iframe Wordt Geblokkeerd

**Probleem:** Browser blokkeert iframe

**Oplossing:**
- Controleer of je site HTTPS gebruikt
- Check Content Security Policy headers
- Test in verschillende browsers

### Shortcode Toont Letterlijk

**Probleem:** `[bookingflow]` wordt als tekst getoond

**Oplossing:**
- Plugin niet geactiveerd - activeer via Plugins menu
- Cache issue - clear WordPress cache
- Theme conflict - test met default theme (Twenty Twenty-Four)

---

## Support

**Email:** support@bookingflow.nl
**Telefoon:** +31 (0)85 060 60 60
**Bereikbaar:** Ma-Vr 09:00-17:00
**Website:** bookingflow.nl

---

## Veel Gestelde Vragen

**Q: Heb ik een BookingFlow account nodig?**
A: Ja, je hebt een actief BookingFlow account nodig. Aanmelden kan op bookingflow.nl/signup

**Q: Wat kost BookingFlow?**
A: De WordPress plugin is gratis. BookingFlow abonnementen starten vanaf €29/maand.

**Q: Werkt dit met mijn theme?**
A: Ja, de plugin werkt met alle moderne WordPress themes.

**Q: Kan ik meerdere booking widgets plaatsen?**
A: Ja, plaats de shortcode op meerdere pagina's. Voor verschillende accounts gebruik verschillende slugs.

**Q: Is de widget responsive?**
A: Ja, de widget werkt perfect op desktop, tablet en mobile.

---

**Versie:** 1.0.0
**Laatste update:** November 2025
**Ontwikkelaar:** BookingFlow
**Licentie:** GPL v2 or later
